#pragma rtGlobals=1		// Use modern global access method.
#pragma version=3.1

// ******** MPR Differentiator *******

Function MPRDiffReset()
	MPRDiffSetupDesign()
	SetAxis/A/Z bottom			// in case user set a manual X axis range
	Execute "mprDiffCompute(\"\")"
End

Function ButtonMPRDifferentiator(ctrlName) : ButtonControl
	String ctrlName

	DoWindow/F WMMPRDiffDesign
	if( V_Flag==0 )
		MPRDiffSetupDesign()
	endif
End

Function MPRDiffSetupDesign()

	SetApplyButtonTitle(0)

	NVAR fs= root:Packages:WM_IFDL:fs

	String dfSav= Set_IFDL_DataFolder()
	
	Variable nt=NumVarOrDefault("md_n",10)
	Variable b1end=NumVarOrDefault("md_b1e",0.3)
	Variable slope=NumVarOrDefault("md_slp",1)

	// Create the globals
	Variable/G md_n=nt
	Variable/G md_b1e=b1end
	Variable/G md_slp=slope

	// scale the saved normalized frequencies for the SetVariable controls
	Variable/G md_b1e_fs= b1end * fs

	SetDataFolder dfSav

	MPRDiffUpdate()
	CreateWMMPRDiffDesign()
	MPRDiffUpdate()			// set the control limits, too.
End

// update waves that show the MPR Differentiator design parameters
// This is called whenever any parameters change.
Function MPRDiffUpdate()
	NVAR fs= root:Packages:WM_IFDL:fs

	String dfSav= Set_IFDL_DataFolder()
	Variable nt=NumVarOrDefault("md_n",10)
	Variable b1endFs=NumVarOrDefault("md_b1e_fs",0.3 * fs)
	Variable slope=NumVarOrDefault("md_slp",1)

	// Save the normalized frequencies in case the user changes sampling frequency
	Variable/G md_b1e= b1endFs/fs
	
	// keep number of terms even
	Variable/G md_n= 2 * trunc((nt+1)/2)

	// Passband response pair, linear response
	Variable responseAtb1End= slope*b1endFs/fs
	Make/O md_responseX = {0,b1endFs}
	Make/O md_response  = {0,responseAtb1End}

	// transition region waves
	Variable maxResponse
	WAVE filterResult= root:Packages:WM_IFDL:coefsMag
	DoWindow WMMPRDiffDesign
	if( V_Flag == 1 )
		CheckDisplayed/W=WMMPRDiffDesign coefsMag
	endif
	if( V_Flag == 1 )
		maxResponse= MaximumInBand(filterResult,b1endFs,fs/2)
	else
		maxResponse= responseAtb1End * 1.4	// approximate
	endif

	Make/O     md_transitionX = {b1endFs,fs/2}
	Make/O/N=2 md_transitionPlus =  max(responseAtb1End,maxResponse)
	Make/O/N=2 md_transitionMinus = 0

	SetDataFolder dfSav

	DoUpdate
End

Function CreateWMMPRDiffDesign()

	if( DesignGraph("WMMPRDiffDesign","MPR Differentiator Design") )
		return 1	// already existed, don't reset the graph settings.
	endif
	NVAR fs= root:Packages:WM_IFDL:fs

	String dfSav= Set_IFDL_DataFolder()
	AppendToGraph/L=responseLeft md_transitionPlus,md_transitionMinus vs md_transitionX
	AppendToGraph/L=responseLeft md_response vs md_responseX
	Variable df= NiceNumber(fs/200)	// 1,2,5 increment for SetVariable controls
	SetDataFolder dfSav

	ModifyGraph mode(md_transitionPlus)=7
	ModifyGraph lSize(md_transitionPlus)=0,lSize(md_transitionMinus)=0
	ModifyGraph rgb(md_transitionPlus)=(56797,56797,56797)
	ModifyGraph hbFill(md_transitionPlus)=2
	ModifyGraph toMode(md_transitionPlus)=1

	ModifyGraph lblPos(responseLeft)=60
	ModifyGraph freePos(responseLeft)={0,bottom}
	ModifyGraph margin(left)=67
	ModifyGraph minor(bottom)=1
	SetAxis/A/N=1 responseLeft
	Label responseLeft "response"
	ControlBar 59
	SetVariable md_b1e,pos={14,4},size={211,17},proc=MPR_diff,title="End of First Band"
	SetVariable md_b1e,limits={0,fs/2,df},value= root:Packages:WM_IFDL:md_b1e_fs
	SetVariable md_slope,pos={86,23},size={139,17},proc=MPR_diff,title="Slope"
	SetVariable md_slope,limits={0.001,Inf,0.5},value= root:Packages:WM_IFDL:md_slp
	SetVariable md_n,pos={295,4},size={166,17},proc=MPR_diff,title="Number of Terms"
	SetVariable md_n,limits={6,9999,2},value= root:Packages:WM_IFDL:md_n
	Button mdCompute,pos={314,30},size={109,20},proc=mprDiffCompute,title="Compute Filter"
	ValDisplay valdisp0,pos={20,42},size={228,14},fSize=9
	ValDisplay valdisp0,format="Slope = Gain / fraction-of-sampling-frequency",frame=0
	ValDisplay valdisp0,limits={0,0,0},barmisc={0,1000},value= #"0"
	Textbox/N=mdLegend/X=1.24/Y=1.58 ""
	mdLegend()
	SetWindow WMMPRDiffDesign, hook=designHook
	return 0
End

Function MPR_diff(ctrlName,varNum,varStr,varName) : SetVariableControl
	String ctrlName
	Variable varNum
	String varStr
	String varName

	MPRDiffUpdate()
End

Function mdLegend()
	DesignLegend("WMMPRDiffDesign","md","mdLegend")
End

Proc mprDiffCompute(ctrlName) : ButtonControl
	String ctrlName

	Silent 1;PauseUpdate	// 	MPR Differentiator...
	String dfSav= Set_IFDL_DataFolder()
	Variable b1endFs= md_b1e_fs
	Variable slope= md_slp
	Variable nt= md_n

	String/G proposedFilterName="mprDifferentiator"
	String/G designTypeName= "McClellan-Parks; differentiator"
	Variable/G designFlags=4
	Make/O bandInfo={slope,0,b1endFs}
	SetDataFolder dfSav

	Variable fs = root:Packages:WM_IFDL:fs

	if( nt > 9999 )
		Abort "Too many filter terms. Max is 9999."
	endif 

	if( ChkFreq(b1endFs/fs,0,0,0) )
		abort
	endif

	Set_IFDL_DataFolder()

	String mpDes="des",mpWt="wt",mpGrid="grid"
	MPRMakeWaves(mpDes,mpWt,mpGrid,nt)
	$mpDes=slope*x
	$mpWt=1/x
	$mpGrid[0]=NaN
	$mpGrid(b1endFs/fs,)=NaN

	SetDataFolder dfSav
	Make/O/N=(nt) coefs=0
	MPKernel(mpDes,mpWt,mpGrid,"coefs",1)
	StdCoefsTreatmentNoShowResults(0x2D,1)

	DoWindow/F WMMPRDiffDesign
	CheckDisplayed/W=WMMPRDiffDesign root:Packages:WM_IFDL:coefsMag
	if( V_Flag == 0 )
		Append/L=responseLeft root:Packages:WM_IFDL:coefsMag
		ModifyGraph rgb(coefsMag)=(0,0,65535)
		ReorderTraces md_response, {coefsMag}	// put actual response under desired response
	endif
	AppendPassDetails("detailsLeft",root:Packages:WM_IFDL:md_diffError)
	Label detailsLeft "error"
	MPRDiffUpdate()
	AutoApplyFilter()
	mdLegend()
End
